/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common.team.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_5251;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeam;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamConfig;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamKey;
import xyz.nucleoid.plasmid.api.game.common.team.provider.ConstantTeamListProvider;
import xyz.nucleoid.plasmid.api.game.common.team.provider.RandomTeamListProvider;
import xyz.nucleoid.plasmid.api.game.common.team.provider.TeamListProvider;
import xyz.nucleoid.plasmid.api.game.common.team.provider.TrimTeamListProvider;

public final class DefaultTeamLists {
    private static final GameTeam BLUE = DefaultTeamLists.createTeam(class_1767.field_7966);
    private static final GameTeam GREEN = DefaultTeamLists.createTeam(class_1767.field_7942);
    private static final GameTeam YELLOW = DefaultTeamLists.createTeam(class_1767.field_7947);
    private static final GameTeam ORANGE = DefaultTeamLists.createTeam(class_1767.field_7946);
    private static final GameTeam RED = DefaultTeamLists.createTeam(class_1767.field_7964);
    private static final GameTeam BROWN = DefaultTeamLists.createTeam(class_1767.field_7957);
    private static final GameTeam LIME = DefaultTeamLists.createTeam(class_1767.field_7961);
    private static final GameTeam LIGHT_BLUE = DefaultTeamLists.createTeam(class_1767.field_7951);
    private static final GameTeam PINK = DefaultTeamLists.createTeam(class_1767.field_7954);
    private static final GameTeam PURPLE = DefaultTeamLists.createTeam(class_1767.field_7945);
    private static final GameTeam CYAN = DefaultTeamLists.createTeam(class_1767.field_7955);
    private static final GameTeam MAGENTA = DefaultTeamLists.createTeam(class_1767.field_7958);
    private static final GameTeam WHITE = DefaultTeamLists.createTeam(class_1767.field_7952);
    private static final GameTeam BLACK = DefaultTeamLists.createTeam(class_1767.field_7963);
    private static final GameTeam GRAY = DefaultTeamLists.createTeam(class_1767.field_7944);
    private static final GameTeam LIGHT_GRAY = DefaultTeamLists.createTeam(class_1767.field_7967);
    private static final GameTeam LIGHT_BLUE_AS_BLUE = DefaultTeamLists.createTeam("blue", class_1767.field_7951);
    private static final GameTeam LIME_AS_GREEN = DefaultTeamLists.createTeam("green", class_1767.field_7961);
    private static final GameTeam MAGENTA_AS_PURPLE = DefaultTeamLists.createTeam("purple", class_1767.field_7958);
    private static final TeamListProvider RANDOM_TWO = DefaultTeamLists.ofLists(List.of(List.of(LIGHT_BLUE_AS_BLUE, RED), List.of(BLUE, ORANGE), List.of(LIME_AS_GREEN, MAGENTA_AS_PURPLE), List.of(YELLOW, PURPLE), List.of(PINK, CYAN), List.of(RED, GREEN), List.of(LIGHT_BLUE_AS_BLUE, ORANGE)));
    private static final TeamListProvider RANDOM_FOUR = DefaultTeamLists.ofLists(List.of(List.of(RED, BLUE, LIME_AS_GREEN, YELLOW), List.of(LIME_AS_GREEN, ORANGE, PINK, CYAN)));
    private static final List<GameTeam> POOL_SMALLEST = List.of(LIGHT_BLUE_AS_BLUE, LIME_AS_GREEN, YELLOW, RED);
    private static final List<GameTeam> POOL_FIVE = List.of(LIGHT_BLUE_AS_BLUE, LIME_AS_GREEN, YELLOW, RED, MAGENTA_AS_PURPLE);
    private static final List<GameTeam> POOL_SEVEN = List.of(LIGHT_BLUE_AS_BLUE, LIME_AS_GREEN, YELLOW, ORANGE, RED, MAGENTA_AS_PURPLE, BROWN);
    private static final List<GameTeam> POOL_TEN = List.of(BLUE, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, PURPLE);
    private static final List<GameTeam> POOL_TWELVE = List.of(BLUE, CYAN, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, MAGENTA, PURPLE);
    private static final List<GameTeam> POOL_FOURTEEN = List.of(BLUE, CYAN, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, MAGENTA, PURPLE, WHITE, BLACK);
    private static final List<GameTeam> POOL_BIGGEST = List.of(BLUE, CYAN, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, MAGENTA, PURPLE, WHITE, LIGHT_GRAY, GRAY, BLACK);
    public static final Map<Integer, TeamListProvider> MAP = DefaultTeamLists.buildMap();

    private static Map<Integer, TeamListProvider> buildMap() {
        HashMap<Integer, TeamListProvider> map = new HashMap<Integer, TeamListProvider>();
        for (int i = 1; i <= 16; ++i) {
            map.put(i, DefaultTeamLists.getEntry(i));
        }
        return map;
    }

    private static TeamListProvider getEntry(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Team list cannot be empty. Please provide a valid size between 0 and 16.");
        }
        if (size > 16) {
            throw new IllegalArgumentException("Team list cannot be over 16. Please provide a valid size between than 0 and 16.");
        }
        if (size == 2) {
            return RANDOM_TWO;
        }
        if (size == 4) {
            return RANDOM_FOUR;
        }
        if (size > 14) {
            return DefaultTeamLists.ofPool(POOL_BIGGEST, size);
        }
        if (size > 12) {
            return DefaultTeamLists.ofPool(POOL_FOURTEEN, size);
        }
        if (size > 10) {
            return DefaultTeamLists.ofPool(POOL_TWELVE, size);
        }
        if (size > 7) {
            return DefaultTeamLists.ofPool(POOL_TEN, size);
        }
        if (size > 5) {
            return DefaultTeamLists.ofPool(POOL_SEVEN, size);
        }
        if (size > 4) {
            return DefaultTeamLists.ofPool(POOL_FIVE, size);
        }
        return DefaultTeamLists.ofPool(POOL_SMALLEST, size);
    }

    private static TeamListProvider ofLists(List<List<GameTeam>> lists) {
        return new RandomTeamListProvider(lists.stream().map(teamList -> new ConstantTeamListProvider((List<GameTeam>)teamList)).toList());
    }

    private static TeamListProvider ofPool(List<GameTeam> pool, int size) {
        return new TrimTeamListProvider(new ConstantTeamListProvider(pool), size);
    }

    private static GameTeam createTeam(String name, class_1767 dyeColor) {
        GameTeamConfig.Colors colors = dyeColor == class_1767.field_7963 ? new GameTeamConfig.Colors(class_124.field_1063, class_5251.method_27717((int)dyeColor.method_7787()), dyeColor, class_5251.method_27717((int)dyeColor.method_7790())) : GameTeamConfig.Colors.from(dyeColor);
        return new GameTeam(new GameTeamKey(name), GameTeamConfig.builder().setName((class_2561)class_2561.method_43471((String)("color.minecraft." + name))).setColors(colors).build());
    }

    private static GameTeam createTeam(class_1767 dyeColor) {
        return DefaultTeamLists.createTeam(dyeColor.method_7792(), dyeColor);
    }
}

