/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.event;

import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpaceState;
import xyz.nucleoid.stimuli.event.StimulusEvent;

public final class GameActivityEvents {
    public static final StimulusEvent<Enable> ENABLE = StimulusEvent.create(Enable.class, ctx -> () -> {
        try {
            for (Enable listener : ctx.getListeners()) {
                listener.onEnable();
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Disable> DISABLE = StimulusEvent.create(Disable.class, ctx -> () -> {
        try {
            for (Disable listener : ctx.getListeners()) {
                listener.onDisable();
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Create> CREATE = StimulusEvent.create(Create.class, ctx -> () -> {
        try {
            for (Create listener : ctx.getListeners()) {
                listener.onCreate();
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Destroy> DESTROY = StimulusEvent.create(Destroy.class, ctx -> reason -> {
        try {
            for (Destroy listener : ctx.getListeners()) {
                listener.onDestroy(reason);
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Tick> TICK = StimulusEvent.create(Tick.class, ctx -> () -> {
        try {
            for (Tick listener : ctx.getListeners()) {
                listener.onTick();
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<RequestStart> REQUEST_START = StimulusEvent.create(RequestStart.class, ctx -> () -> {
        try {
            for (RequestStart listener : ctx.getListeners()) {
                GameResult result = listener.onRequestStart();
                if (result == null) continue;
                return result;
            }
            return null;
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
            return GameResult.error((class_2561)class_2561.method_43471((String)"text.plasmid.game.start_result.error"));
        }
    });
    public static final StimulusEvent<StateUpdate> STATE_UPDATE = StimulusEvent.create(StateUpdate.class, ctx -> builder -> {
        try {
            for (StateUpdate listener : ctx.getListeners()) {
                builder = listener.onStateUpdate(builder);
            }
            return builder;
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
            return builder;
        }
    });

    public static interface StateUpdate {
        public GameSpaceState.Builder onStateUpdate(GameSpaceState.Builder var1);
    }

    public static interface RequestStart {
        @Nullable
        public GameResult onRequestStart();
    }

    public static interface Tick {
        public void onTick();
    }

    public static interface Destroy {
        public void onDestroy(GameCloseReason var1);
    }

    public static interface Create {
        public void onCreate();
    }

    public static interface Disable {
        public void onDisable();
    }

    public static interface Enable {
        public void onEnable();
    }
}

