/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.event;

import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptor;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptorResult;
import xyz.nucleoid.plasmid.api.game.player.JoinOffer;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;
import xyz.nucleoid.stimuli.event.StimulusEvent;

public final class GamePlayerEvents {
    public static final StimulusEvent<Add> ADD = StimulusEvent.create(Add.class, ctx -> player -> {
        try {
            for (Add listener : ctx.getListeners()) {
                listener.onAddPlayer(player);
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Remove> REMOVE = StimulusEvent.create(Remove.class, ctx -> player -> {
        try {
            for (Remove listener : ctx.getListeners()) {
                listener.onRemovePlayer(player);
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Add> JOIN = StimulusEvent.create(Add.class, ctx -> player -> {
        try {
            for (Add listener : ctx.getListeners()) {
                listener.onAddPlayer(player);
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Remove> LEAVE = StimulusEvent.create(Remove.class, ctx -> player -> {
        try {
            for (Remove listener : ctx.getListeners()) {
                listener.onRemovePlayer(player);
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
    });
    public static final StimulusEvent<Offer> OFFER = StimulusEvent.create(Offer.class, ctx -> offer -> {
        try {
            for (Offer listener : ctx.getListeners()) {
                JoinOfferResult result = listener.onOfferPlayers(offer);
                if (result instanceof JoinOfferResult.Pass) continue;
                return result;
            }
            return offer.accept();
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
            return offer.reject((class_2561)GameTexts.Join.unexpectedError());
        }
    });
    public static final StimulusEvent<Accept> ACCEPT = StimulusEvent.create(Accept.class, ctx -> accept -> {
        try {
            for (Accept listener : ctx.getListeners()) {
                JoinAcceptorResult result = listener.onAcceptPlayers(accept);
                if (result instanceof JoinAcceptorResult.Pass) continue;
                return result;
            }
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
        }
        return accept.pass();
    });
    public static final StimulusEvent<Name> DISPLAY_NAME = StimulusEvent.create(Name.class, ctx -> (player, current, vanillaText) -> {
        try {
            for (Name listener : ctx.getListeners()) {
                current = listener.onDisplayNameCreation(player, current, vanillaText);
            }
            return current;
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
            return vanillaText;
        }
    });
    public static final StimulusEvent<JoinMessage> JOIN_MESSAGE = StimulusEvent.create(JoinMessage.class, ctx -> (player, current, defaultText) -> {
        try {
            for (JoinMessage listener : ctx.getListeners()) {
                current = listener.onJoinMessageCreation(player, current, defaultText);
            }
            return current;
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
            return defaultText;
        }
    });
    public static final StimulusEvent<LeaveMessage> LEAVE_MESSAGE = StimulusEvent.create(LeaveMessage.class, ctx -> (player, current, defaultText) -> {
        try {
            for (LeaveMessage listener : ctx.getListeners()) {
                current = listener.onLeaveMessageCreation(player, current, defaultText);
            }
            return current;
        }
        catch (Throwable throwable) {
            ctx.handleException(throwable);
            return defaultText;
        }
    });

    public static interface LeaveMessage {
        @Nullable
        public class_2561 onLeaveMessageCreation(class_3222 var1, @Nullable class_2561 var2, class_2561 var3);
    }

    public static interface JoinMessage {
        @Nullable
        public class_2561 onJoinMessageCreation(class_3222 var1, @Nullable class_2561 var2, class_2561 var3);
    }

    public static interface Name {
        public class_2561 onDisplayNameCreation(class_3222 var1, class_2561 var2, class_2561 var3);
    }

    public static interface Accept {
        public JoinAcceptorResult onAcceptPlayers(JoinAcceptor var1);
    }

    public static interface Offer {
        public JoinOfferResult onOfferPlayers(JoinOffer var1);
    }

    public static interface Remove {
        public void onRemovePlayer(class_3222 var1);
    }

    public static interface Add {
        public void onAddPlayer(class_3222 var1);
    }
}

