/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.player;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import xyz.nucleoid.plasmid.api.event.GameEvents;
import xyz.nucleoid.plasmid.api.game.GameOpenException;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.impl.Plasmid;

public final class GamePlayerJoiner {
    public static GameResult tryJoin(class_3222 player, GameSpace gameSpace, JoinIntent intent) {
        try {
            Set<class_3222> players = GamePlayerJoiner.collectPlayersForJoin(player, gameSpace);
            return GamePlayerJoiner.tryJoinAll(players, gameSpace, intent);
        }
        catch (Throwable throwable) {
            return GamePlayerJoiner.handleJoinException(throwable);
        }
    }

    private static Set<class_3222> collectPlayersForJoin(class_3222 player, GameSpace gameSpace) {
        ReferenceOpenHashSet players = new ReferenceOpenHashSet();
        players.add(player);
        ((GameEvents.CollectPlayersForJoin)GameEvents.COLLECT_PLAYERS_FOR_JOIN.invoker()).collectPlayersForJoin(gameSpace, player, (Set<class_3222>)players);
        return players;
    }

    private static GameResult tryJoinAll(Collection<class_3222> players, GameSpace gameSpace, JoinIntent intent) {
        return gameSpace.getPlayers().offer(players, intent);
    }

    public static GameResult handleJoinException(Throwable throwable) {
        Plasmid.LOGGER.error("Failed to add player to game space!", throwable);
        return GameResult.error(GamePlayerJoiner.getFeedbackForException(throwable));
    }

    private static class_2561 getFeedbackForException(Throwable throwable) {
        GameOpenException gameOpenException = GameOpenException.unwrap(throwable);
        if (gameOpenException != null) {
            return gameOpenException.getReason().method_27661();
        }
        return GameTexts.Join.unexpectedError();
    }
}

