/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.player;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptorResult;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.util.PlayerPos;

public interface JoinAcceptor {
    public Set<GameProfile> players();

    default public Set<UUID> playerIds() {
        return this.players().stream().map(GameProfile::id).collect(Collectors.toSet());
    }

    default public Set<String> playerNames() {
        return this.players().stream().map(GameProfile::name).collect(Collectors.toSet());
    }

    public JoinIntent intent();

    public JoinAcceptorResult.Teleport teleport(Map<UUID, PlayerPos> var1);

    public JoinAcceptorResult.Teleport teleport(Function<GameProfile, PlayerPos> var1);

    public JoinAcceptorResult.Teleport teleport(class_3218 var1, class_243 var2, float var3, float var4);

    default public JoinAcceptorResult.Teleport teleport(class_3218 world, class_243 position) {
        return this.teleport(world, position, 0.0f, 0.0f);
    }

    default public JoinAcceptorResult pass() {
        return JoinAcceptorResult.PASS;
    }

    default public JoinAcceptorResult ifSpectator(Function<JoinAcceptor, JoinAcceptorResult> spectatorFunction) {
        if (this.intent() == JoinIntent.SPECTATE) {
            return spectatorFunction.apply(this);
        }
        return this.pass();
    }

    default public JoinAcceptorResult ifParticipant(Function<JoinAcceptor, JoinAcceptorResult> participantFunction) {
        if (this.intent() == JoinIntent.PLAY) {
            return participantFunction.apply(this);
        }
        return this.pass();
    }
}

