/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.player;

import com.mojang.authlib.GameProfile;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;

public interface JoinOffer {
    public Set<GameProfile> players();

    default public Set<UUID> playerIds() {
        return this.players().stream().map(GameProfile::id).collect(Collectors.toSet());
    }

    default public Set<String> playerNames() {
        return this.players().stream().map(GameProfile::name).collect(Collectors.toSet());
    }

    public JoinIntent intent();

    default public JoinOfferResult.Accept accept() {
        return JoinOfferResult.ACCEPT;
    }

    public JoinOfferResult.Reject reject(class_2561 var1);

    default public JoinOfferResult pass() {
        return JoinOfferResult.PASS;
    }

    default public JoinOfferResult acceptSpectators() {
        return this.acceptSpectatorsOrElse(x -> x.reject((class_2561)GameTexts.Join.spectatorsOnly()));
    }

    default public JoinOfferResult acceptSpectatorsOrElse(Function<JoinOffer, JoinOfferResult> function) {
        return this.intent() == JoinIntent.SPECTATE ? this.accept() : function.apply(this);
    }

    default public JoinOfferResult acceptParticipants() {
        return this.acceptParticipantsOrElse(x -> x.reject((class_2561)GameTexts.Join.participantsOnly()));
    }

    default public JoinOfferResult acceptParticipantsOrElse(Function<JoinOffer, JoinOfferResult> function) {
        return this.intent() == JoinIntent.PLAY ? this.accept() : function.apply(this);
    }
}

