/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.player;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.player.PlayerSet;
import xyz.nucleoid.plasmid.api.util.PlayerRef;

public final class MutablePlayerSet
implements PlayerSet {
    private final Function<UUID, class_3222> playerGetter;
    private final Set<UUID> players = new ObjectOpenHashSet();

    public MutablePlayerSet(MinecraftServer server) {
        this.playerGetter = arg_0 -> ((class_3324)server.method_3760()).method_14602(arg_0);
    }

    public MutablePlayerSet(class_3218 world) {
        this.playerGetter = uuid -> {
            class_3222 player;
            class_1657 patt0$temp = world.method_18470(uuid);
            return patt0$temp instanceof class_3222 ? (player = (class_3222)patt0$temp) : null;
        };
    }

    public MutablePlayerSet(GameSpace gameSpace) {
        this.playerGetter = gameSpace.getPlayers()::getEntity;
    }

    public void clear() {
        this.players.clear();
    }

    public boolean add(class_3222 player) {
        return this.players.add(player.method_5667());
    }

    public boolean add(PlayerRef ref) {
        return this.players.add(ref.id());
    }

    public boolean remove(class_3222 player) {
        return this.players.remove(player.method_5667());
    }

    public boolean remove(PlayerRef ref) {
        return this.players.remove(ref.id());
    }

    public boolean remove(UUID id) {
        return this.players.remove(id);
    }

    @Override
    @Nullable
    public class_3222 getEntity(UUID id) {
        return this.players.contains(id) ? this.playerGetter.apply(id) : null;
    }

    @Override
    public boolean contains(UUID id) {
        return this.players.contains(id);
    }

    @Override
    @NotNull
    public Iterator<class_3222> iterator() {
        final Function<UUID, class_3222> playerGetter = this.playerGetter;
        final Iterator<UUID> ids = this.players.iterator();
        return new AbstractIterator<class_3222>(this){

            protected class_3222 computeNext() {
                while (ids.hasNext()) {
                    UUID id = (UUID)ids.next();
                    class_3222 player = (class_3222)playerGetter.apply(id);
                    if (player == null) continue;
                    return player;
                }
                return (class_3222)this.endOfData();
            }
        };
    }

    @Override
    public int size() {
        return this.players.size();
    }
}

