/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.player;

import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.player.MutablePlayerSet;
import xyz.nucleoid.plasmid.api.game.player.PlayerIterable;
import xyz.nucleoid.plasmid.api.util.PlayerRef;
import xyz.nucleoid.plasmid.impl.player.EmptyPlayerSet;
import xyz.nucleoid.plasmid.impl.player.ServerPlayerSet;
import xyz.nucleoid.plasmid.impl.player.ServerWorldPlayerSet;

public interface PlayerSet
extends PlayerIterable {
    public static final PlayerSet EMPTY = EmptyPlayerSet.INSTANCE;

    public static PlayerSet ofServer(MinecraftServer server) {
        return new ServerPlayerSet(server.method_3760());
    }

    public static PlayerSet ofWorld(class_3218 world) {
        return new ServerWorldPlayerSet(world);
    }

    public boolean contains(UUID var1);

    default public boolean contains(PlayerRef ref) {
        return this.contains(ref.id());
    }

    default public boolean contains(class_3222 player) {
        return this.contains(player.method_5667());
    }

    @Nullable
    public class_3222 getEntity(UUID var1);

    public int size();

    default public boolean isEmpty() {
        return this.size() <= 0;
    }

    default public MutablePlayerSet copy(MinecraftServer server) {
        MutablePlayerSet copy = new MutablePlayerSet(server);
        this.forEach(copy::add);
        return copy;
    }

    @Override
    @NotNull
    public Iterator<class_3222> iterator();
}

