/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.stats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.BiConsumer;
import xyz.nucleoid.plasmid.api.game.stats.StatisticKey;

public class StatisticMap {
    private final Object2ObjectMap<StatisticKey<?>, Number> values = new Object2ObjectOpenHashMap();

    public void increment(StatisticKey<Double> key, double amount) {
        this.values.put(key, (Object)((Double)this.values.getOrDefault(key, (Object)0.0) + amount));
    }

    public void increment(StatisticKey<Float> key, float amount) {
        this.values.put(key, (Object)Float.valueOf(((Float)this.values.getOrDefault(key, (Object)Float.valueOf(0.0f))).floatValue() + amount));
    }

    public void increment(StatisticKey<Integer> key, int amount) {
        this.values.put(key, (Object)((Integer)this.values.getOrDefault(key, (Object)0) + amount));
    }

    public <T extends Number> T get(StatisticKey<T> key, T defaultValue) {
        return (T)((Number)this.values.getOrDefault(key, defaultValue));
    }

    public void set(StatisticKey<Double> key, double value) {
        this.values.put(key, (Object)value);
    }

    public void set(StatisticKey<Float> key, float value) {
        this.values.put(key, (Object)Float.valueOf(value));
    }

    public void set(StatisticKey<Integer> key, int value) {
        this.values.put(key, (Object)value);
    }

    public JsonObject encode() {
        JsonObject obj = new JsonObject();
        for (Object2ObjectMap.Entry entry : this.values.object2ObjectEntrySet()) {
            JsonObject stat = ((StatisticKey)entry.getKey()).encodeValueUnchecked((Number)entry.getValue());
            obj.add(((StatisticKey)entry.getKey()).id().toString(), (JsonElement)stat);
        }
        return obj;
    }

    public void visitAllStatistics(BiConsumer<StatisticKey<?>, Number> visitor) {
        for (Object2ObjectMap.Entry entry : this.values.object2ObjectEntrySet()) {
            visitor.accept((StatisticKey)entry.getKey(), (Number)entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }
}

