/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public final class Scheduler {
    public static final Scheduler INSTANCE = new Scheduler();
    private final ConcurrentLinkedQueue<Task> taskQueue = new ConcurrentLinkedQueue();
    private int currentTick = 0;

    private Scheduler() {
        ServerTickEvents.END_SERVER_TICK.register(this::runTasks);
    }

    public <T> CompletableFuture<T> submit(Function<MinecraftServer, T> task) {
        return this.submit(task, 0);
    }

    public <T> CompletableFuture<T> submit(Function<MinecraftServer, T> task, int delay) {
        CompletableFuture future = new CompletableFuture();
        this.submit((MinecraftServer server) -> {
            Object result = task.apply((MinecraftServer)server);
            future.complete(result);
        }, delay);
        return future;
    }

    public void submit(Consumer<MinecraftServer> task) {
        this.submit(task, 0);
    }

    public void submit(Consumer<MinecraftServer> task, int delay) {
        this.taskQueue.add(new OneshotTask(task, this.currentTick + delay));
    }

    public void repeat(Consumer<MinecraftServer> task, int delay, int interval) {
        this.repeatWhile(task, null, delay, interval);
    }

    public void repeatWhile(Consumer<MinecraftServer> task, IntPredicate condition, int delay, int interval) {
        int beginTime = this.currentTick + delay;
        this.enqueue(new DoWhileTask(task, condition, beginTime, interval));
    }

    private void enqueue(Task task) {
        this.taskQueue.add(task);
    }

    private void runTasks(MinecraftServer server) {
        int time;
        this.currentTick = time = server.method_3780();
        this.taskQueue.removeIf(task -> task.tryRun(server, time));
    }

    private record OneshotTask(Consumer<MinecraftServer> action, int time) implements Task
    {
        @Override
        public boolean tryRun(MinecraftServer server, int time) {
            if (time >= this.time) {
                this.action.accept(server);
                return true;
            }
            return false;
        }
    }

    private static class DoWhileTask
    implements Task {
        private final Consumer<MinecraftServer> task;
        private final IntPredicate condition;
        private final int interval;
        private int nextTime;

        private DoWhileTask(Consumer<MinecraftServer> task, IntPredicate condition, int beginTime, int interval) {
            this.task = task;
            this.condition = condition;
            this.nextTime = beginTime;
            this.interval = interval;
        }

        @Override
        public boolean tryRun(MinecraftServer server, int time) {
            if (time >= this.nextTime) {
                this.task.accept(server);
                this.nextTime = time + this.interval;
                return !this.shouldRepeat(time);
            }
            return false;
        }

        private boolean shouldRepeat(int predicate) {
            IntPredicate condition = this.condition;
            return condition == null || condition.test(predicate);
        }
    }

    private static interface Task {
        public boolean tryRun(MinecraftServer var1, int var2);
    }
}

