/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TinyRegistry<T>
implements Codec<T> {
    private final BiMap<class_2960, T> map = HashBiMap.create();

    private TinyRegistry() {
    }

    public static <T> TinyRegistry<T> create() {
        return new TinyRegistry<T>();
    }

    public void clear() {
        this.map.clear();
    }

    public void register(class_2960 identifier, T value) {
        this.map.put((Object)identifier, value);
    }

    @Nullable
    public T get(class_2960 identifier) {
        return (T)this.map.get((Object)identifier);
    }

    @Nullable
    public class_2960 getIdentifier(T value) {
        return (class_2960)this.map.inverse().get(value);
    }

    public boolean containsKey(class_2960 identifier) {
        return this.map.containsKey((Object)identifier);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
        return class_2960.field_25139.decode(ops, input).flatMap(pair -> {
            if (!this.containsKey((class_2960)pair.getFirst())) {
                return DataResult.error(() -> "Unknown registry key: " + String.valueOf(pair.getFirst()));
            }
            return DataResult.success((Object)pair.mapFirst(this::get));
        });
    }

    public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
        class_2960 identifier = this.getIdentifier(input);
        if (identifier == null) {
            return DataResult.error(() -> "Unknown registry element " + String.valueOf(input));
        }
        return ops.mergeToPrimitive(prefix, ops.createString(identifier.toString()));
    }

    public Set<class_2960> keySet() {
        return this.map.keySet();
    }

    public Collection<T> values() {
        return this.map.values();
    }

    @Deprecated
    public static class Fake<T>
    extends TinyRegistry<T> {
        private final class_2378<T> registry;

        public Fake(class_2378<T> registry) {
            this.registry = registry;
        }

        @Override
        public void clear() {
        }

        @Override
        public void register(class_2960 identifier, T value) {
            class_2378.method_10230(this.registry, (class_2960)identifier, value);
        }

        @Override
        @Nullable
        public class_2960 getIdentifier(T value) {
            return this.registry.method_10221(value);
        }

        @Override
        public boolean containsKey(class_2960 identifier) {
            return this.registry.method_10250(identifier);
        }

        @Override
        public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
            return this.registry.method_39673().decode(ops, input);
        }

        @Override
        public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
            return this.registry.method_39673().encode(input, ops, prefix);
        }

        @Override
        public Set<class_2960> keySet() {
            return this.registry.method_10235();
        }

        @Override
        public Collection<T> values() {
            return this.registry.method_10220().toList();
        }
    }
}

