/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.PlasmidWebServer;

public record PlasmidConfig(boolean ignoreInvalidGames, Optional<String> userFacingPackAddress, Optional<PlasmidWebServer.Config> webServerConfig) {
    private static final Path PATH = Paths.get("config/plasmid.json", new String[0]);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Codec<PlasmidConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("ignore_invalid_game_configs", (Object)false).forGetter(PlasmidConfig::ignoreInvalidGames), (App)Codec.STRING.optionalFieldOf("resource_pack_address").forGetter(PlasmidConfig::userFacingPackAddress), (App)PlasmidWebServer.Config.CODEC.optionalFieldOf("web_server").forGetter(PlasmidConfig::webServerConfig)).apply((Applicative)instance, PlasmidConfig::new));
    private static PlasmidConfig instance;

    private PlasmidConfig() {
        this(false, Optional.of("http://127.0.0.1:25566/resource-packs"), Optional.of(new PlasmidWebServer.Config(25566)));
    }

    @NotNull
    public static PlasmidConfig get() {
        if (instance == null) {
            instance = PlasmidConfig.initializeConfig();
        }
        return instance;
    }

    private static PlasmidConfig initializeConfig() {
        if (Files.exists(PATH, new LinkOption[0])) {
            return PlasmidConfig.loadConfig();
        }
        return PlasmidConfig.createDefaultConfig();
    }

    private static PlasmidConfig loadConfig() {
        PlasmidConfig plasmidConfig;
        block8: {
            InputStream input = Files.newInputStream(PATH, new OpenOption[0]);
            try {
                JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(input));
                DataResult result = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst);
                plasmidConfig = result.result().orElseGet(PlasmidConfig::new);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Plasmid.LOGGER.warn("Failed to load Plasmid config", (Throwable)e);
                    return new PlasmidConfig();
                }
            }
            input.close();
        }
        return plasmidConfig;
    }

    private static PlasmidConfig createDefaultConfig() {
        PlasmidConfig config = new PlasmidConfig();
        try (OutputStream output = Files.newOutputStream(PATH, new OpenOption[0]);){
            Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).result();
            if (result.isPresent()) {
                JsonElement json = (JsonElement)result.get();
                IOUtils.write((String)GSON.toJson(json), (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            Plasmid.LOGGER.warn("Failed to create default Plasmid config", (Throwable)e);
        }
        return config;
    }
}

