/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl;

import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import net.minecraft.class_156;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.PlasmidConfig;

public class PlasmidWebServer {
    public static final String RESOURCE_PACKS_ENDPOINT = "resource-packs";
    private static final Map<String, Path> RESOURCE_PACKS = new HashMap<String, Path>();
    private static final String WEB_URL = (String)class_156.method_656(() -> {
        String path = PlasmidConfig.get().userFacingPackAddress().orElse("");
        return path.endsWith("/") ? path : path + "/";
    });

    @Nullable
    public static HttpServer start(MinecraftServer minecraftServer, Config config) {
        try {
            InetSocketAddress address = PlasmidWebServer.createBindAddress(minecraftServer, config);
            HttpServer server = HttpServer.create(address, 0);
            server.createContext("/resource-packs", new ResourcePacksHandler(RESOURCE_PACKS_ENDPOINT));
            server.setExecutor(Executors.newFixedThreadPool(2));
            server.start();
            Plasmid.LOGGER.info("Web server started at: " + String.valueOf(address));
            return server;
        }
        catch (IOException e) {
            Plasmid.LOGGER.error("Failed to start the web server!", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    private static InetSocketAddress createBindAddress(MinecraftServer server, Config config) {
        String serverIp = server.method_3819();
        if (!Strings.isNullOrEmpty((String)serverIp)) {
            return new InetSocketAddress(serverIp, config.port());
        }
        return new InetSocketAddress(config.port());
    }

    public static String registerResourcePack(String s, Path path) {
        RESOURCE_PACKS.put(s, path);
        return WEB_URL + s;
    }

    public record Config(int port) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("port").forGetter(Config::port)).apply((Applicative)instance, Config::new));
    }

    private record ResourcePacksHandler(String endpoint) implements HttpHandler
    {
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try (HttpExchange httpExchange = exchange;){
                if (!this.tryHandle(exchange)) {
                    exchange.sendResponseHeaders(404, 0L);
                }
            }
        }

        private boolean tryHandle(HttpExchange exchange) throws IOException {
            if ("GET".equals(exchange.getRequestMethod())) {
                return this.tryHandleGet(exchange);
            }
            return false;
        }

        private boolean tryHandleGet(HttpExchange exchange) throws IOException {
            String path = exchange.getRequestURI().getPath().substring(this.endpoint.length() + 2);
            Path pack = RESOURCE_PACKS.get(path);
            if (pack != null) {
                long size = Files.size(pack);
                try (InputStream input = Files.newInputStream(pack, new OpenOption[0]);){
                    boolean bl;
                    block13: {
                        OutputStream output = exchange.getResponseBody();
                        try {
                            exchange.getResponseHeaders().add("Server", "plasmid");
                            exchange.getResponseHeaders().add("Content-Type", "application/zip");
                            exchange.sendResponseHeaders(201, size);
                            input.transferTo(output);
                            output.flush();
                            bl = true;
                            if (output == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        output.close();
                    }
                    return bl;
                }
            }
            return false;
        }
    }
}

