/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.command.ui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.GameSpaceState;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.game.player.GamePlayerJoiner;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.util.Guis;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;

public class GameJoinUi
extends SimpleGui {
    private static final GuiElementInterface EMPTY = new GuiElementBuilder(class_1802.field_8871).hideTooltip().build();
    private static final int NAVBAR_POS = 81;
    private final class_3222 player;
    private final JoinIntent joinIntent;
    private int tick;
    private int page = 0;
    private int pageSize;

    public GameJoinUi(class_3222 player, JoinIntent intent) {
        super(class_3917.field_17327, player, true);
        this.joinIntent = intent;
        this.player = player;
        this.setTitle((class_2561)class_2561.method_43471((String)"text.plasmid.ui.game_join.title"));
        this.updateUi();
    }

    private static void tryJoinGame(class_3222 player, GameSpace gameSpace, JoinIntent joinIntent) {
        player.method_51469().method_8503().execute(() -> {
            GameResult result = GamePlayerJoiner.tryJoin(player, gameSpace, joinIntent);
            if (result.isError()) {
                player.method_64398((class_2561)result.errorCopy().method_27692(class_124.field_1061));
            }
        });
    }

    public void onTick() {
        super.onTick();
        ++this.tick;
        if (this.tick % 20 == 0) {
            this.updateUi();
        }
    }

    private void updateUi() {
        int i = 0;
        int gameI = 0;
        ArrayList<GameSpace> games = new ArrayList<GameSpace>(GameSpaceManagerImpl.get().getOpenGameSpaces());
        games.sort(Comparator.comparingInt(space -> -space.getPlayers().size()));
        int limit = this.size;
        this.pageSize = 0;
        if (games.size() > this.size) {
            limit = 81;
            this.pageSize = games.size() / 81;
        }
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)this.pageSize);
        for (GameSpace gameSpace : games) {
            if (gameI >= this.page * 81 && i < limit) {
                this.setSlot(i++, (GuiElementBuilderInterface)this.createIconFor(gameSpace));
            }
            ++gameI;
        }
        while (i < limit) {
            this.clearSlot(i);
            ++i;
        }
        if (this.pageSize != 0) {
            boolean hasPrevious = this.page != 0;
            boolean hasNext = this.page < this.pageSize;
            this.setSlot(81, EMPTY);
            this.setSlot(82, EMPTY);
            this.setSlot(83, (GuiElementBuilderInterface)new GuiElementBuilder(hasPrevious ? class_1802.field_8581 : class_1802.field_8157).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_27692(hasPrevious ? class_124.field_1065 : class_124.field_1063)).setCallback((x, y, z) -> this.changePage(-1)));
            int pageValue = this.page + 1;
            class_5455 registries = this.player.method_56673();
            this.setSlot(84, Guis.getNumericBanner((class_7871.class_7872)registries, pageValue / 100));
            this.setSlot(85, Guis.getNumericBanner((class_7871.class_7872)registries, pageValue / 10));
            this.setSlot(86, Guis.getNumericBanner((class_7871.class_7872)registries, pageValue));
            this.setSlot(87, (GuiElementBuilderInterface)new GuiElementBuilder(hasNext ? class_1802.field_8581 : class_1802.field_8157).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_27692(hasNext ? class_124.field_1065 : class_124.field_1063)).setCallback((x, y, z) -> this.changePage(1)));
            this.setSlot(88, EMPTY);
            this.setSlot(89, EMPTY);
        }
    }

    private void changePage(int change) {
        this.page = class_3532.method_15340((int)(this.page + change), (int)0, (int)this.pageSize);
        this.updateUi();
    }

    private GuiElementBuilder createIconFor(GameSpace gameSpace) {
        GamePortalBackend.ActionType actionType;
        GameSpaceState state = gameSpace.getState();
        class_6880<GameConfig<?>> sourceConfig = gameSpace.getMetadata().sourceConfig();
        GuiElementBuilder element = GuiElementBuilder.from((class_1799)((GameConfig)sourceConfig.comp_349()).icon().method_7972()).hideDefaultTooltip().setName((class_2561)GameConfig.name(sourceConfig).method_27661());
        for (class_2561 line : ((GameConfig)sourceConfig.comp_349()).description()) {
            class_5250 text = line.method_27661();
            if (line.method_10866().method_10973() == null) {
                text.method_10862(line.method_10866().method_10977(class_124.field_1080));
            }
            element.addLoreLine((class_2561)text);
        }
        boolean allowSpace = true;
        if (!state.state().hidden()) {
            element.addLoreLine(class_5244.field_39003);
            element.addLoreLine((class_2561)class_2561.method_43470((String)" ").method_10852(state.state().display()).method_27692(class_124.field_1068));
            allowSpace = false;
        }
        if (state.players() > -1) {
            if (allowSpace) {
                element.addLoreLine(class_5244.field_39003);
                allowSpace = false;
            }
            element.addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43469((String)"text.plasmid.ui.game_join.players", (Object[])new Object[]{class_2561.method_43470((String)(state.players() + (String)(state.maxPlayers() > 0 ? " / " + state.maxPlayers() : ""))).method_27692(class_124.field_1054)}).method_27692(class_124.field_1065)));
        }
        if (state.spectators() > 0) {
            if (allowSpace) {
                element.addLoreLine(class_5244.field_39003);
                allowSpace = false;
            }
            element.addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43469((String)"text.plasmid.ui.game_join.spectators", (Object[])new Object[]{class_2561.method_43470((String)("" + state.spectators())).method_27692(class_124.field_1054)}).method_27692(class_124.field_1065)));
        }
        GamePortalBackend.ActionType actionType2 = actionType = this.joinIntent == JoinIntent.PLAY ? GamePortalBackend.ActionType.PLAY : GamePortalBackend.ActionType.SPECTATE;
        if (actionType != GamePortalBackend.ActionType.NONE) {
            element.addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)" [ ").method_27692(class_124.field_1080)).method_10852(actionType.text()).method_10852((class_2561)class_2561.method_43470((String)" ]").method_27692(class_124.field_1080)).method_10862(class_2583.field_24360.method_36139(7794031)));
        }
        element.hideDefaultTooltip();
        element.setCallback((a, b, c, d) -> GameJoinUi.tryJoinGame(this.getPlayer(), gameSpace, this.joinIntent));
        return element;
    }
}

