/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.manager;

import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import xyz.nucleoid.plasmid.api.event.GameEvents;
import xyz.nucleoid.plasmid.api.game.GameBehavior;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.event.GameActivityEvents;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameActivity;
import xyz.nucleoid.stimuli.event.EventResult;
import xyz.nucleoid.stimuli.event.StimulusEvent;

final class GameActivityState
implements GameBehavior {
    private final GameSpace gameSpace;
    private ManagedGameActivity activity;

    GameActivityState(GameSpace gameSpace) {
        this.gameSpace = gameSpace;
    }

    void setActivity(Supplier<ManagedGameActivity> factory) {
        ManagedGameActivity activity;
        GameSpace gameSpace = this.gameSpace;
        ManagedGameActivity closedActivity = this.activity;
        this.gameSpace.getLifecycle().beforeActivityChange(gameSpace, this.activity, closedActivity);
        if (closedActivity != null) {
            GameActivityState.disableActivity(gameSpace, closedActivity);
            GameActivityState.destroyActivity(gameSpace, closedActivity, GameCloseReason.SWAPPED);
        }
        this.activity = activity = factory.get();
        GameActivityState.createActivity(gameSpace, activity);
        GameActivityState.enableActivity(gameSpace, activity);
        this.gameSpace.getLifecycle().afterActivityChange(gameSpace, activity, closedActivity);
    }

    boolean closeActivity(GameCloseReason reason) {
        ManagedGameActivity activity = this.activity;
        if (activity == null) {
            return false;
        }
        this.activity = null;
        GameSpace gameSpace = this.gameSpace;
        GameActivityState.disableActivity(gameSpace, activity);
        GameActivityState.destroyActivity(gameSpace, activity, reason);
        return true;
    }

    private static void createActivity(GameSpace gameSpace, ManagedGameActivity activity) {
        activity.propagatingInvoker(GameActivityEvents.CREATE).onCreate();
        ((GameEvents.CreateActivity)GameEvents.CREATE_ACTIVITY.invoker()).onCreateActivity(gameSpace, activity);
    }

    private static void enableActivity(GameSpace gameSpace, ManagedGameActivity activity) {
        for (class_3222 player : gameSpace.getPlayers()) {
            activity.propagatingInvoker(GamePlayerEvents.ADD).onAddPlayer(player);
        }
        activity.propagatingInvoker(GameActivityEvents.ENABLE).onEnable();
    }

    private static void disableActivity(GameSpace gameSpace, ManagedGameActivity activity) {
        activity.invoker(GameActivityEvents.DISABLE).onDisable();
        for (class_3222 player : gameSpace.getPlayers()) {
            activity.invoker(GamePlayerEvents.REMOVE).onRemovePlayer(player);
        }
    }

    private static void destroyActivity(GameSpace gameSpace, ManagedGameActivity activity, GameCloseReason reason) {
        activity.invoker(GameActivityEvents.DESTROY).onDestroy(reason);
        activity.onDestroy();
        ((GameEvents.DestroyActivity)GameEvents.DESTROY_ACTIVITY.invoker()).onDestroyActivity(gameSpace, activity, reason);
    }

    @Override
    @NotNull
    public <T> T invoker(StimulusEvent<T> event) {
        ManagedGameActivity activity = this.activity;
        return (T)(activity != null ? activity.invoker(event) : event.emptyInvoker());
    }

    @Override
    @NotNull
    public <T> T propagatingInvoker(StimulusEvent<T> event) {
        ManagedGameActivity activity = this.activity;
        return (T)(activity != null ? activity.propagatingInvoker(event) : event.emptyInvoker());
    }

    @Override
    @NotNull
    public <T> Iterable<T> getInvokers(StimulusEvent<T> event) {
        ManagedGameActivity activity = this.activity;
        return activity != null ? activity.getInvokers(event) : Collections.emptyList();
    }

    @Override
    @NotNull
    public EventResult testRule(GameRuleType rule) {
        ManagedGameActivity activity = this.activity;
        return activity != null ? activity.testRule(rule) : EventResult.PASS;
    }
}

