/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.manager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import org.apache.commons.lang3.RandomStringUtils;
import xyz.nucleoid.plasmid.api.game.GameType;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;

final class GameSpaceUserIdManager {
    private final Multimap<GameType<?>, class_2960> typeToIds = HashMultimap.create();
    private final Map<class_2960, GameType<?>> idToType = new Object2ObjectOpenHashMap();

    GameSpaceUserIdManager() {
    }

    public class_2960 acquire(GameConfig<?> config) {
        GameType<?> type = config.type();
        Collection ids = this.typeToIds.get(type);
        class_2960 uniqueId = this.generateUniqueId(type, ids);
        ids.add(uniqueId);
        this.idToType.put(uniqueId, type);
        return uniqueId;
    }

    public void release(class_2960 id) {
        GameType<?> config = this.idToType.remove(id);
        if (config != null) {
            this.typeToIds.remove(config, (Object)id);
        }
    }

    private class_2960 generateUniqueId(GameType<?> type, Collection<class_2960> ids) {
        class_2960 typeId;
        class_2960 uniqueId = typeId = this.getIdForType(type);
        while (ids.contains(uniqueId)) {
            uniqueId = this.generateRandomId(typeId);
        }
        return uniqueId;
    }

    private class_2960 generateRandomId(class_2960 typeId) {
        String random = RandomStringUtils.randomAlphabetic((int)4).toLowerCase(Locale.ROOT);
        return class_2960.method_60655((String)typeId.method_12836(), (String)(typeId.method_12832() + "/" + random));
    }

    private class_2960 getIdForType(GameType<?> type) {
        return type.id();
    }
}

