/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.player;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptor;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptorResult;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.game.player.PlayerSet;
import xyz.nucleoid.plasmid.api.util.PlayerPos;

public record LocalJoinAcceptor(Collection<class_3222> serverPlayers, JoinIntent intent) implements JoinAcceptor
{
    @Override
    public Set<GameProfile> players() {
        return this.serverPlayers.stream().map(class_1657::method_7334).collect(Collectors.toSet());
    }

    @Override
    public Set<UUID> playerIds() {
        return this.serverPlayers.stream().map(player -> player.method_7334().id()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> playerNames() {
        return this.serverPlayers.stream().map(player -> player.method_7334().name()).collect(Collectors.toSet());
    }

    @Override
    public JoinAcceptorResult.Teleport teleport(Map<UUID, PlayerPos> positions) {
        if (this.serverPlayers.stream().anyMatch(player -> !positions.containsKey(player.method_5667()))) {
            throw new IllegalArgumentException("Positions for all players must be specified");
        }
        return new Teleport(positions);
    }

    @Override
    public JoinAcceptorResult.Teleport teleport(Function<GameProfile, PlayerPos> positions) {
        return new Teleport(this.serverPlayers.stream().collect(Collectors.toMap(class_1297::method_5667, player -> (PlayerPos)positions.apply(player.method_7334()))));
    }

    @Override
    public JoinAcceptorResult.Teleport teleport(class_3218 world, class_243 position, float yaw, float pitch) {
        PlayerPos playerPos = new PlayerPos(world, position, yaw, pitch);
        return new Teleport(this.serverPlayers.stream().collect(Collectors.toMap(class_1297::method_5667, player -> playerPos)));
    }

    public static class Teleport
    implements JoinAcceptorResult.Teleport {
        private final Map<UUID, PlayerPos> positions;
        private final List<BiConsumer<PlayerSet, JoinIntent>> thenRun = new ArrayList<BiConsumer<PlayerSet, JoinIntent>>();

        Teleport(Map<UUID, PlayerPos> positions) {
            this.positions = positions;
        }

        @Override
        public JoinAcceptorResult.Teleport thenRun(BiConsumer<PlayerSet, JoinIntent> consumer) {
            this.thenRun.add(consumer);
            return this;
        }

        public void runCallbacks(PlayerSet players, JoinIntent intent) {
            for (BiConsumer<PlayerSet, JoinIntent> consumer : this.thenRun) {
                consumer.accept(players, intent);
            }
        }

        public class_3218 applyTeleport(class_3222 player) {
            PlayerPos pos = this.positions.get(player.method_5667());
            player.method_7336(class_1934.field_9215);
            player.method_5808(pos.x(), pos.y(), pos.z(), pos.yaw(), pos.pitch());
            return pos.world();
        }
    }
}

