/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.mixin.game.portal;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8104;
import net.minecraft.class_8113;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.nucleoid.plasmid.impl.compatibility.DisguiseLibCompatibility;
import xyz.nucleoid.plasmid.impl.portal.GamePortal;
import xyz.nucleoid.plasmid.impl.portal.GamePortalDisplay;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements GamePortalInterface {
    @Shadow
    public class_1937 field_6002;
    @Unique
    private TextDisplayElement textDisplayElement;
    @Unique
    private ElementHolder hologram;
    @Unique
    private GamePortal portal;
    @Unique
    private class_2960 loadedPortalId;

    @Shadow
    public abstract class_243 method_73189();

    @Override
    public boolean interactWithPortal(class_3222 player) {
        if (this.portal != null) {
            this.portal.requestJoin(player, false);
            return true;
        }
        return false;
    }

    @Override
    public void setPortal(GamePortal portal) {
        this.portal = portal;
        if (portal == null) {
            this.removeHologram();
        }
    }

    @Override
    @Nullable
    public GamePortal getPortal() {
        return this.portal;
    }

    @Override
    public void setDisplay(GamePortalDisplay display) {
        TextDisplayElement hologram = this.getOrCreateTextElement();
        class_5250 text = class_2561.method_43473();
        class_2561 name = display.get(GamePortalDisplay.NAME);
        Integer playerCount = display.get(GamePortalDisplay.PLAYER_COUNT);
        if (name != null && playerCount != null) {
            text.method_10852(name);
            if (playerCount > -1) {
                text.method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"text.plasmid.game.portal.player_count", (Object[])new Object[]{playerCount}));
            }
        }
        hologram.setText((class_2561)text);
        if (hologram.isDirty()) {
            hologram.tick();
        }
    }

    @Unique
    private TextDisplayElement getOrCreateTextElement() {
        if (this.hologram != null) {
            return this.textDisplayElement;
        }
        class_1297 entity = (class_1297)this;
        class_243 offset = new class_243(0.0, DisguiseLibCompatibility.getEntityHeight(entity) + 0.2, 0.0);
        this.hologram = new ElementHolder();
        this.textDisplayElement = new TextDisplayElement();
        this.textDisplayElement.setOffset(offset);
        this.textDisplayElement.setBrightness(new class_8104(15, 15));
        this.textDisplayElement.setBillboardMode(class_8113.class_8114.field_42409);
        this.textDisplayElement.setDisplayWidth(5.0f);
        this.textDisplayElement.setDisplayHeight(1.0f);
        this.textDisplayElement.setViewRange(0.5f);
        this.hologram.addElement((VirtualElement)this.textDisplayElement);
        EntityAttachment.of((ElementHolder)this.hologram, (class_1297)((class_1297)this));
        return this.textDisplayElement;
    }

    private void removeHologram() {
        ElementHolder hologram = this.hologram;
        this.hologram = null;
        if (hologram != null) {
            hologram.destroy();
            this.textDisplayElement = null;
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.loadedPortalId != null && this.tryConnectTo(this.loadedPortalId)) {
            this.loadedPortalId = null;
        }
    }

    @Inject(method={"method_5647(Lnet/minecraft/class_11372;)V"}, at={@At(value="RETURN")})
    private void writePortalData(class_11372 view, CallbackInfo ci) {
        if (this.loadedPortalId == null) {
            this.serializePortal(view);
        } else {
            view.method_71469(GamePortalInterface.NBT_KEY, this.loadedPortalId.toString());
        }
    }

    @Inject(method={"method_5651(Lnet/minecraft/class_11368;)V"}, at={@At(value="RETURN")})
    private void readPortalData(class_11368 view, CallbackInfo ci) {
        this.loadedPortalId = this.deserializePortalId(view);
    }

    @Inject(method={"method_5650(Lnet/minecraft/class_1297$class_5529;)V"}, at={@At(value="HEAD")})
    private void remove(CallbackInfo ci) {
        this.invalidatePortal();
        this.removeHologram();
    }
}

