/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.mixin.game.portal;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_8242;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.nucleoid.plasmid.impl.portal.GamePortal;
import xyz.nucleoid.plasmid.impl.portal.GamePortalDisplay;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;

@Mixin(value={class_2625.class})
public abstract class SignBlockEntityMixin
extends class_2586
implements GamePortalInterface {
    @Unique
    private GamePortal portal;
    @Unique
    private class_2960 loadedPortalId;

    @Shadow
    public abstract class_8242 method_49843(boolean var1);

    @Shadow
    public abstract boolean method_49840(class_8242 var1, boolean var2);

    @Shadow
    public abstract boolean method_49855();

    @Shadow
    public abstract boolean method_49849(boolean var1);

    private SignBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void setPortal(GamePortal portal) {
        this.portal = portal;
    }

    @Override
    @Nullable
    public GamePortal getPortal() {
        return this.portal;
    }

    @Override
    public void setDisplay(GamePortalDisplay display) {
        class_2561[] lines = new class_2561[4];
        for (int i = 0; i < 4; ++i) {
            lines[i] = this.getDisplayLine(display, i);
        }
        class_8242 oldText = this.method_49843(true);
        this.method_49840(new class_8242(lines, lines, oldText.method_49872(), oldText.method_49856()), true);
        this.method_49849(true);
        if (this.method_11002()) {
            class_2680 cachedState = this.method_11010();
            this.field_11863.method_8413(this.field_11867, cachedState, cachedState, 3);
        }
    }

    @NotNull
    private class_2561 getDisplayLine(GamePortalDisplay display, int line) {
        Integer playerCount;
        if (line == 1) {
            class_2561 name = display.get(GamePortalDisplay.NAME);
            if (name != null) {
                return name;
            }
        } else if (line == 2 && (playerCount = display.get(GamePortalDisplay.PLAYER_COUNT)) != null) {
            return class_2561.method_43469((String)"text.plasmid.game.portal.player_count", (Object[])new Object[]{playerCount});
        }
        return class_5244.field_39003;
    }

    @Inject(method={"method_50010(ZLnet/minecraft/class_1657;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canRunCommandClickEvent(CallbackInfoReturnable<Boolean> ci) {
        if (this.method_49855() && this.portal != null) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"method_50007(Lnet/minecraft/class_3218;Lnet/minecraft/class_1657;Lnet/minecraft/class_2338;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void runCommandClickEvent(class_3218 world, class_1657 player, class_2338 pos, boolean front, CallbackInfoReturnable<Boolean> ci) {
        if (this.portal != null && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.portal.requestJoin(serverPlayer, false);
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"method_11007(Lnet/minecraft/class_11372;)V"}, at={@At(value="RETURN")})
    private void writePortalNbt(class_11372 view, CallbackInfo ci) {
        this.serializePortal(view);
    }

    @Inject(method={"method_11014(Lnet/minecraft/class_11368;)V"}, at={@At(value="RETURN")})
    private void readPortalData(class_11368 view, CallbackInfo ci) {
        this.loadedPortalId = this.deserializePortalId(view);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        MinecraftServer server = world.method_8503();
        if (server != null && this.loadedPortalId != null) {
            this.tryConnectTo(this.loadedPortalId);
            this.loadedPortalId = null;
        }
    }

    @Override
    public boolean updatePortalImmediately() {
        return this.loadedPortalId == null;
    }

    public void method_11012() {
        super.method_11012();
        this.invalidatePortal();
    }
}

