/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.stimuli;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.stimuli.EventInvokers;
import xyz.nucleoid.stimuli.EventSource;
import xyz.nucleoid.stimuli.NoOPSelectorEventInvokers;
import xyz.nucleoid.stimuli.SelectorEventInvokers;
import xyz.nucleoid.stimuli.event.StimulusEvent;
import xyz.nucleoid.stimuli.selector.EventListenerSelector;
import xyz.nucleoid.stimuli.selector.ListenerSelectorSet;

public final class StimuliSelector {
    private final ListenerSelectorSet selectors;

    StimuliSelector(ListenerSelectorSet selectors) {
        this.selectors = selectors;
    }

    public EventInvokers at(class_1937 world, class_2338 pos) {
        return this.acquireInvokers(world.method_8503(), EventSource.at(world, pos));
    }

    public EventInvokers forEntity(class_1297 entity) {
        return this.acquireInvokers(entity.method_73183().method_8503(), EventSource.forEntity(entity));
    }

    public EventInvokers forEntityAt(class_1297 entity, class_2338 pos) {
        return this.acquireInvokers(entity.method_73183().method_8503(), EventSource.forEntityAt(entity, pos));
    }

    public EventInvokers forCommandSource(class_2168 source) {
        return this.acquireInvokers(source.method_9211(), EventSource.forCommandSource(source));
    }

    EventInvokers acquireInvokers(@Nullable MinecraftServer server, EventSource source) {
        if (server == null) {
            return NoOPSelectorEventInvokers.INSTANCE;
        }
        return SelectorEventInvokers.acquire(server, this, source);
    }

    <T> Iterator<T> selectListeners(MinecraftServer server, StimulusEvent<T> event, EventSource source) {
        return new ListenerIterator<T>(server, event, source, this.selectors.getArray());
    }

    static final class ListenerIterator<T>
    extends AbstractIterator<T> {
        private final MinecraftServer server;
        private final StimulusEvent<T> event;
        private final EventSource source;
        private final EventListenerSelector[] selectors;
        private int selectorIndex;
        private Iterator<T> currentIterator;

        ListenerIterator(MinecraftServer server, StimulusEvent<T> event, EventSource source, EventListenerSelector[] selectors) {
            this.server = server;
            this.event = event;
            this.source = source;
            this.selectors = selectors;
        }

        protected T computeNext() {
            EventListenerSelector[] selectors = this.selectors;
            Iterator<T> currentIterator = this.currentIterator;
            while (currentIterator == null || !currentIterator.hasNext()) {
                int index;
                ++this.selectorIndex;
                if (index >= selectors.length) {
                    return (T)this.endOfData();
                }
                EventListenerSelector selector = selectors[index];
                currentIterator = selector.selectListeners(this.server, this.event, this.source);
                this.currentIterator = currentIterator;
            }
            return currentIterator.next();
        }
    }
}

