/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.stimuli.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import xyz.nucleoid.stimuli.util.PooledObject;

public interface ObjectPool<T extends PooledObject<T>> {
    public static <T extends PooledObject<T>> ObjectPool<T> create(int capacity, PooledObject.Factory<T> factory) {
        if (capacity == 1) {
            return new UnaryAtomic<T>(factory);
        }
        return new FixedAtomic<T>(capacity, factory);
    }

    public T acquire();

    public void release(T var1);

    public static final class UnaryAtomic<T extends PooledObject<T>>
    implements ObjectPool<T> {
        private final AtomicReference<T> object = new AtomicReference();
        private final PooledObject.Factory<T> factory;

        UnaryAtomic(PooledObject.Factory<T> factory) {
            this.factory = factory;
        }

        @Override
        public T acquire() {
            PooledObject<Object> object = this.object.getAndSet(null);
            if (object == null) {
                object = this.factory.create(this);
            }
            return (T)object;
        }

        @Override
        public void release(T object) {
            this.object.compareAndSet(null, object);
        }
    }

    public static final class FixedAtomic<T extends PooledObject<T>>
    implements ObjectPool<T> {
        private final int capacity;
        private final AtomicReferenceArray<T> array;
        private final AtomicInteger pointer = new AtomicInteger(-1);
        private final PooledObject.Factory<T> factory;

        FixedAtomic(int capacity, PooledObject.Factory<T> factory) {
            this.capacity = capacity;
            this.array = new AtomicReferenceArray(capacity);
            this.factory = factory;
        }

        @Override
        public T acquire() {
            PooledObject object;
            int pointer;
            do {
                if ((pointer = this.pointer.get()) >= 0) continue;
                return this.factory.create(this);
            } while (!this.pointer.compareAndSet(pointer, pointer - 1) || (object = (PooledObject)this.array.getAndSet(pointer, null)) == null);
            return (T)object;
        }

        @Override
        public void release(T object) {
            int newPointer;
            int pointer;
            do {
                if ((newPointer = (pointer = this.pointer.get()) + 1) < this.capacity) continue;
                return;
            } while (!this.pointer.compareAndSet(pointer, newPointer));
            this.array.set(newPointer, object);
        }
    }
}

