/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.stimuli;

import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.stimuli.util.ObjectPool;
import xyz.nucleoid.stimuli.util.PooledObject;

public final class EventSource
extends PooledObject<EventSource> {
    private static final ObjectPool<EventSource> POOL = ObjectPool.create(16, EventSource::new);
    private static final EventSource GLOBAL = new EventSource(null);
    private class_5321<class_1937> dimension;
    private class_2338 pos;
    private class_1297 entity;

    private EventSource(ObjectPool<EventSource> pool) {
        super(pool);
    }

    void set(class_5321<class_1937> dimension, class_2338 pos, class_1297 entity) {
        this.dimension = dimension;
        this.pos = pos;
        this.entity = entity;
    }

    public static EventSource global() {
        return GLOBAL;
    }

    public static EventSource at(class_1937 world, class_2338 pos) {
        return EventSource.acquire((class_5321<class_1937>)world.method_27983(), pos, null);
    }

    public static EventSource at(class_5321<class_1937> dimension, class_2338 pos) {
        return EventSource.acquire(dimension, pos, null);
    }

    public static EventSource allOf(class_1937 world) {
        return EventSource.acquire((class_5321<class_1937>)world.method_27983(), null, null);
    }

    public static EventSource allOf(class_5321<class_1937> dimension) {
        return EventSource.acquire(dimension, null, null);
    }

    public static EventSource forEntity(class_1297 entity) {
        return EventSource.acquire((class_5321<class_1937>)entity.method_73183().method_27983(), entity.method_24515(), entity);
    }

    public static EventSource forEntityAt(class_1297 entity, class_2338 pos) {
        return EventSource.acquire((class_5321<class_1937>)entity.method_73183().method_27983(), pos, entity);
    }

    public static EventSource forCommandSource(class_2168 source) {
        return EventSource.acquire((class_5321<class_1937>)source.method_9225().method_27983(), class_2338.method_49638((class_2374)source.method_9222()), source.method_9228());
    }

    static EventSource acquire(class_5321<class_1937> dimension, class_2338 pos, @Nullable class_1297 entity) {
        EventSource source = POOL.acquire();
        source.set(dimension, pos, entity);
        return source;
    }

    @Nullable
    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    @Nullable
    public class_2338 getPos() {
        return this.pos;
    }

    @Nullable
    public class_1297 getEntity() {
        return this.entity;
    }

    @Override
    protected void release() {
        this.set(null, null, null);
    }
}

